/*
 * File:    mcf5xxx.c
 * Purpose: Generic high-level routines for generic ColdFire processors
 *
 * Notes:       
 * 
 * License:     All software covered by license agreement in -
 *              docs/Freescale_Software_License.pdf
 */

#include "support_common.h"

/********************************************************************/
/*
 * Write new interrupt vector handler into the vector table
 * Return previous handler address
 */ 

uint32
mcf5xxx_set_handler (int vector, uint32 new_handler)
{
    uint32 old_handler;
    extern uint32 __VECTOR_RAM[];

    old_handler = (uint32) __VECTOR_RAM[vector];
    __VECTOR_RAM[vector] = (uint32)new_handler;
    return old_handler;
}

/********************************************************************/
